<%@ LANGUAGE="VBScript" %>

<% '***************************************************************************
   '* ASP Football Pool                                                       *
   '*                                                                         *
   '* Copyright 2000 by Mike Hall                                             *
   '* Please see http://www.brainjar.com for documentation and terms of use.  *
   '***************************************************************************
%>

<!-- #include file="protect.inc" -->
<!-- #include file="common.inc" -->
<!-- #include file="header.inc" -->

<% 'Open the database.

   call OpenDB()

   'Default to current week if none was specified.

   week = Request("week")
   if week = "" then
     week = CurrentWeek()
   end if

   'Display that week's schedule. %>

<p><table class="formatted" cellpadding=0 cellspacing=0>
<tr><th colspan=8>Week <% = week %></th></tr>
<%   sql = "select Schedule.*," _
         & " Teams.City as VCity, Teams.Name as VName, Teams.DisplayName as VDisplayName," _
         & " Teams2.City as HCity, Teams2.Name as HName, Teams2.DisplayName as HDisplayName" _
         & " from (Schedule inner join Teams on Schedule.VisitorID = Teams.TeamID)" _
         & " inner join Teams as Teams2 on Schedule.HomeID = Teams2.TeamID" _
         & " where Schedule.Week = " & week _
         & " order by Schedule.Date, Schedule.Time, Teams.City, Teams.Name"
   set rs = DbConn.Execute(sql)
   if not (rs.BOF and rs.EOF) then
     n = 0
     do while not rs.EOF
       visitor = rs.Fields("VCity").Value
       home    = rs.Fields("HCity").Value
       vscore  = rs.Fields("VisitorScore").Value
       hscore  = rs.Fields("HomeScore").Value
       ot      = rs.Fields("OT").Value
       result  = rs.Fields("Result").Value
       if rs.Fields("VDisplayName") <> "" then
         visitor = rs.Fields("VDisplayName").Value
       end if
       if rs.Fields("HDisplayName") <> "" then
         home = rs.Fields("HDisplayName")
       end if
       if result = rs.Fields("VisitorID").Value then
           visitor = "<b>" & visitor & "</b>"
           vscore = "<b>" & vscore & "</b>"
       elseif result = rs.Fields("HomeID").Value then
           home = "<b>" & home & "</b>"
           hscore = "<b>" & hscore & "</b>"
       end if
       if ot then
         ot = " OT"
       else
         ot = ""
       end if
       if Round(n / 2) * 2 = n then %>
<tr align=right>
<%     else %>
<tr align=right class="alt">
<%     end if
       n = n + 1 %>
  <td><% = WeekdayName(Weekday(rs.Fields("Date").Value), true) %>&nbsp;</td>
  <td><% = FormatDate(rs.Fields("Date").Value) %>&nbsp;</td>
  <td><% = FormatTime(rs.Fields("Time").Value) %>&nbsp;</td>
  <td><% = visitor %>&nbsp;</td>
  <td><% = vscore %>&nbsp;</td>
  <td>at <% = home %>&nbsp;</td>
  <td><% = hscore %>&nbsp;</td>
  <td class="small"><% = ot %>&nbsp;</td>
</tr>
<%     rs.MoveNext
     loop %>
</table></p>

<%   str = OpenDates(week)
     if str <> "" then %>
<p><b>Open Dates:</b> <% = str %></p>
<%   end if
   end if %>

<% 'List weeks. %>

<p><b>Go to week:</b>&nbsp;
<% for i = 1 to NumberOfWeeks() %>
<a href="<% = Request.ServerVariables("SCRIPT_NAME") %>?week=<% = i %>">
<% = i %></a>&nbsp;
<% next %></p>

<!-- #include file="footer.inc" -->
